Attribute VB_Name = "MdlConv"
Option Explicit

Private re(0 To MAX_MEAS_POINT) As Single, im(0 To MAX_MEAS_POINT) As Single

'***********************************************************************************
'  Function name  FGetYTrans
'  Function    FAdmittance conversion
'  Argument    FPID As Long       Packet ID (specify value obtained by BisOpenPacket)
'            G() As Single     Storage destination for G (real part)
'            B() As Single     Storage destination for B (imaginary part)
'            Z0 As Double      Characteristic impedance Z0
'            Ch As Long        Channels (1 to 4)
'  Return value  FSuccessful (True) / Error (False)
'  Functional descriptionsFAcquires the data array of the specified channel and stores the admittance conversion result of the data in the specified array.
'***********************************************************************************
Function GetYTrans(PID As Long, ByRef G() As Single, ByRef B() As Single, z0 As Double, Ch As Long) As Boolean
    Dim pt As Long, tr As Long, zz As Single
    Dim tmp_re As Single, tmp_im As Single, bunbo As Single
    Dim i As Long
    
    GetYTrans = False
    
    If Ch < 1 Or 4 < Ch Then Exit Function
    
    'Obtains the number of measurement points (-1) by specifying an extremely large frequency value.
    If QryFetcPoin(PID, Ch, CDbl(6 * Unit_g), pt) <> 0 Then Exit Function
    
    'Data array acquisition.
    tr = (Ch - 1) * 1024
    If QryTracData(PID, BIS_TRAC1_DAT_RE + tr, 0, pt, re(0)) <> 0 Then Exit Function
    If QryTracData(PID, BIS_TRAC1_DAT_IM + tr, 0, pt, im(0)) <> 0 Then Exit Function
    
    'Admittance calculation
    zz = z0 * 2
    For i = 0 To pt
        tmp_re = (1 - re(i)) * zz
        tmp_im = (-im(i)) * zz
        bunbo = tmp_re ^ 2 + tmp_im ^ 2
        G(i) = ((re(i) * tmp_re) + (im(i) * tmp_im)) / bunbo
        B(i) = ((im(i) * tmp_re) - (re(i) * tmp_im)) / bunbo
        If i = 0 Then tr = i
        If G(tr) < G(i) Then tr = i
    Next i
    
    GetYTrans = True

End Function

'***********************************************************************************
'  Function name  FZYTrans
'  Function    FImpedance conversion
'  Argument    FPID As Long       Packet ID (specify value obtained by BisOpenPacket)
'            re() As Single     Storage destination for R (real part)
'            im() As Single     Storage destination for X (imaginary part)
'            G() As Single     Storage destination for G (real part)
'            pgmax As Long     G (real part) max point.
'            Z0 As Double      Characteristic impedance Z0
'  Return value  F
'  Functional descriptionsFAcquires the data array of the specified channel and stores the impedance conversion result of the data in the specified array.
'***********************************************************************************
Public Sub ZYTrans(ByVal pt As Long, ByRef re() As Single, ByRef im() As Single, ByRef G() As Single, ByRef B() As Single, _
                    ByRef bPhs() As Single, ByVal fr_srch As Integer, ByRef result As structXtalEquConstants, ByRef pgmax As Long, ByVal z0 As Double)
    Dim zz As Double
    Dim real As Double
    Dim tmp_re As Double
    Dim tmp_im As Double
    Dim bunbo1 As Double
    Dim bunbo2 As Double
    Dim i As Long
    Dim phs As Single
    Dim pfr As Long
    Dim ph1, ph2 As Single
    Dim php, pha As Single
    Dim x1, x2 As Double
    Dim f1, f2 As Double
    Dim pfp, pfm As Long
    
    'Impedance calculation
    zz = CDbl(z0 * 2)
    pfr = -1: pfp = -1: pfm = -1
    For i = 0 To pt
        tmp_re = (1 - CDbl(re(i))) * zz
        tmp_im = (-CDbl(im(i))) * zz
        bunbo1 = CDbl(re(i)) ^ 2 + CDbl(im(i)) ^ 2
        bunbo2 = tmp_re ^ 2 + tmp_im ^ 2
        real = ((tmp_re * CDbl(re(i))) + (tmp_im * CDbl(im(i)))) / bunbo1
        G(i) = CSng(((CDbl(re(i)) * tmp_re) + (CDbl(im(i)) * tmp_im)) / bunbo2)
        
        If fr_srch Then
            B(i) = ((CDbl(im(i)) * tmp_re) - (CDbl(re(i)) * tmp_im)) / bunbo2
            
            phs = Atn(B(i) / G(i)) * 180 / pi
            If G(i) < 0 Then
                If B(i) < 0 Then
                    phs = phs - 180
                Else
                    phs = phs + 180
                End If
            End If
            
            If pfr = -1 Then
                If phs <= 0 Then
                    pfr = i  'Searches for 0-degree phase
                End If
                If i = 0 Then
                    ph1 = phs
                Else
                    ph1 = ph2
                End If
                ph2 = phs
            End If
                    
        End If
        
        bPhs(i) = phs
        
        im(i) = CSng(((tmp_im * CDbl(re(i))) - (tmp_re * CDbl(im(i)))) / bunbo1)
        re(i) = CSng(real)
        If i = 0 Then pgmax = i
        If G(pgmax) < G(i) Then pgmax = i
    Next i
    
    If fr_srch Then
        If 0 < pfr Then
            x1 = BufFrq(pfr - 1): x2 = BufFrq(pfr)
            result.dblFr = (0 - ph1) / (ph2 - ph1) * (x2 - x1) + x1
        End If
    End If

End Sub

'***********************************************************************************
'  Function name  FZTrans
'  Function    FImpedance conversion
'  Argument    FPID As Long       Packet ID (specify value obtained by BisOpenPacket)
'            R() As Single     Storage destination for R (real part)
'            X() As Single     Storage destination for X (imaginary part)
'            Z0 As Double      Characteristic impedance Z0
'            Ch As Long        Channels (1 to 4)
'  Return value  FSuccessful (True) / Error (False)
'  Functional descriptionsFAcquires the data array of the specified channel and stores the impedance conversion result of the data in the specified array.
'***********************************************************************************
Public Sub ZTrans(ByVal pt As Long, ByRef re() As Single, ByRef im() As Single, ByVal z0 As Double)
    Dim zz As Double
    Dim real As Double
    Dim tmp_re As Double
    Dim tmp_im As Double
    Dim bunbo As Double
    Dim i As Long
    
    'Impedance calculation
    zz = CDbl(z0 * 2)
    For i = 0 To pt
        tmp_re = (1 - CDbl(re(i))) * zz
        tmp_im = (-CDbl(im(i))) * zz
        bunbo = CDbl(re(i)) ^ 2 + CDbl(im(i)) ^ 2
        real = ((tmp_re * CDbl(re(i))) + (tmp_im * CDbl(im(i)))) / bunbo
        im(i) = CSng(((tmp_im * CDbl(re(i))) - (tmp_re * CDbl(im(i)))) / bunbo)
        re(i) = CSng(real)
    Next i

End Sub

'***********************************************************************************
'  Function name  FGetZTrans
'  Function    FImpedance conversion
'  Argument    FPID As Long       Packet ID (specify value obtained by BisOpenPacket)
'            R() As Single     Storage destination for R (real part)
'            X() As Single     Storage destination for X (imaginary part)
'            Z0 As Double      Characteristic impedance Z0
'            Ch As Long        Channels (1 to 4)
'  Return value  FSuccessful (True) / Error (False)
'  Functional descriptionsFAcquires the data array of the specified channel and stores the impedance conversion result of the data in the specified array.
'***********************************************************************************
Public Function GetZTrans(PID As Long, ByRef R() As Single, ByRef X() As Single, z0 As Double, Ch As Long) As Boolean
    Dim pt As Long, tr As Long, zz As Single
    Dim tmp_re As Single, tmp_im As Single, bunbo As Single
    Dim i As Long
    
    GetZTrans = False
    
    If Ch < 1 Or 4 < Ch Then Exit Function
    
    'Obtains the number of measurement points (-1) by specifying an extremely large frequency value.
    If QryFetcPoin(PID, Ch, CDbl(6 * Unit_g), pt) <> 0 Then Exit Function
    
    'Data array acquisition.
    tr = (Ch - 1) * 1024
    If QryTracData(PID, BIS_TRAC1_DAT_RE + tr, 0, pt, R(0)) <> 0 Then Exit Function
    If QryTracData(PID, BIS_TRAC1_DAT_IM + tr, 0, pt, X(0)) <> 0 Then Exit Function
    
    Call ZTrans(pt, R, X, z0)
    
    GetZTrans = True

End Function

'***********************************************************************************
'  Function name  FGet_X_Y_Interpolation
'  Function    FX Interpolation
'  Argument    FByRef p As Integer     Mesurement point.
'                ByRef x As Double      The output destination of the interpolated frequency point value.
'                ByRef y As Single      The output destination of the interpolated level value.
'                ByRef X_Data() As Double Mesurement frequency(array)
'                ByRef Y_Data() As Single Mesurement data(array)
'  Return value  Fnothing
'  Functional descriptionsFx,y interpolation
'***********************************************************************************
Public Sub Get_X_Y_Interpolation(ByRef p As Integer, ByRef X As Double, ByRef y As Single, ByRef X_Data() As Double, ByRef Y_Data() As Single)
    
    If p = totalP - 1 Then
        X = X_Data(p)
        y = Y_Data(p)
        Exit Sub
    End If
    If p <> 0 Then
        If X_Data(p - 1) < X And X <= X_Data(p) Then
            p = p - 1
        ElseIf X_Data(p) <= X And X < X_Data(p - 1) Then
            p = p - 1
        End If
    End If
        If X_Data(p + 1) = X_Data(p) Then
        y = Y_Data(p) + (Y_Data(p + 1) - Y_Data(p))
    Else
        y = Y_Data(p) + (X - X_Data(p)) * ((Y_Data(p + 1) - Y_Data(p)) / (X_Data(p + 1) - X_Data(p)))
        X = p + (X - X_Data(p)) * ((p + 1) - p) / (X_Data(p + 1) - X_Data(p))
    End If

End Sub

Public Function GetFreqPointData(ByRef bfrq() As Double, ByRef Data() As Single, ByVal tp As Long, ByVal dblFreq As Double) As Single
    Dim i As Integer
    Dim dp As Integer
    Dim dt As Single
    Dim tmp1 As Double
    Dim tmp2 As Double
            
    For i = 0 To tp - 2
        If bfrq(i) <= bfrq(i + 1) Then
            If bfrq(i) <= dblFreq And dblFreq <= bfrq(i + 1) Then
                tmp1 = dblFreq - bfrq(i)
                tmp2 = bfrq(i + 1) - dblFreq
                If tmp1 < tmp2 Then
                    dp = i
                Else
                    dp = i + 1
                End If
                Exit For
            End If
        Else
            If bfrq(i + 1) <= dblFreq And dblFreq <= bfrq(i) Then
                tmp1 = dblFreq - bfrq(i + 1)
                tmp2 = bfrq(i) - dblFreq
                If tmp1 < tmp2 Then
                    dp = i + 1
                Else
                    dp = i
                End If
                Exit For
            End If
        End If
    Next i
    
    If bfrq(dp) = dblFreq Then
        dt = Data(dp)
    Else
        Call Get_X_Y_Interpolation(dp, dblFreq, dt, bfrq(), Data())
    End If
    
    GetFreqPointData = dt
End Function
